/*
 * $Id: pgpP11Key.h,v 1.20.2.2 2001/05/07 19:33:24 ajivsov Exp $
 */

#ifndef Included_pgpP11Key_h
#define Included_pgpP11Key_h


#include "pgpSDKBuildFlags.h"

#include "pgpPubTypes.h"	/* For PGPBoolean and PGPByte */
#include "pgpOpaqueStructs.h"
#include "pgpThreads.h"

PGP_BEGIN_C_DECLARATIONS

PGPPubKey *p11PubFromBuf(PGPContextRef	context,
				PGPByte const *buf, PGPSize len, PGPError *error);
				
PGPSecKey *p11SecFromBuf( PGPContextRef	context,
				PGPByte const *buf, PGPSize len, PGPBoolean v3,
				void *tok, PGPError *error);
				
int p11PubKeyPrefixSize(PGPByte const *buf, PGPSize size);

PGPSecKey *p11SecGenerate( PGPContextRef context, PGPByte pkalg, unsigned bits,
				PGPBoolean fastgen, PGPBoolean v3,
				int progress(void *arg, int c), void *arg,
				void *tok, PGPByte const *passphrase, PGPSize phraseLength,
				PGPBoolean genMaster, PGPError *error);


PGPToken *pgpTokenFromKeyID( const PGPByte *keyid );
PGPToken *pgpTokenGetIndexed( PGPUInt32 tokenID );
PGPUInt32 pgpTokenGetCount( void );
PGPError pgpGetTokenInfo( PGPUInt32 toknumber, PGPTokenInfo *tokenInfo );
PGPError pgpTokenWipe( PGPContextRef context, PGPUInt32 tokenID, PGPByte const *passphrase,
					   PGPSize passphraseLength );
PGPError pgpTokenCheckPassphrase( PGPUInt32 tokenID, PGPByte const *passphrase,
					   PGPSize passphraseLength );
PGPError pgpSyncTokenToKeyDB( PGPContextRef context, PGPKeyDBRef fixedkdb,
							  PGPBoolean doNotify );
PGPError pgpPollTokens( PGPContextRef context, PGPMutex_t *mutex );
PGPError pgpTokenCopyPrivKeyToToken( PGPContextRef context, PGPKeyDBObjRef key,
			PGPBoolean	isMaster,
			PGPByte const *passphrase,
			PGPSize passphraseLength, PGPBoolean hashed,
			PGPByte const *PIN, PGPSize PINlength,
			PGPUInt32 toknumber);
PGPError pgpTokenCopyPubKeyToToken( PGPContextRef context, PGPKeyDBObjRef key,
			PGPUInt32 toknumber, PGPToken *tok );
PGPError pgpDeleteKeyOnToken( PGPContextRef context, 
			const PGPKeyID *keyID, PGPUInt32 toknumber );


PGPError pgpUnloadTCL();
PGPError pgpTokenFreeTCLMem( void *p );

PGP_END_C_DECLARATIONS

#endif /* Included_pgpP11Key_h */
